/*
 * Decompiled with CFR 0.152.
 */
package xjyb.cn.org.bjca.java.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import xjyb.cn.org.bjca.exception.Base64Exception;
import xjyb.cn.org.bjca.framework.SuperUtil;
import xjyb.cn.org.bjca.java.utils.FileUtil;
import xjyb.cn.org.bjca.security.SecurityUtil;
import xjyb.cn.org.bjca.utils.Base64Util;
import xjyb.com.sansec.device.local.WrapCard;
import xjyb.org.bjca.asn1.ASN1Sequence;
import xjyb.org.bjca.asn1.ASN1Set;
import xjyb.org.bjca.asn1.DERBitString;
import xjyb.org.bjca.asn1.DERConstructedSequence;
import xjyb.org.bjca.asn1.DERInputStream;
import xjyb.org.bjca.asn1.pkcs.CertificationRequest;
import xjyb.org.bjca.asn1.x509.SubjectPublicKeyInfo;
import xjyb.org.bjca.asn1.x509.X5094JitRSAEntryConverter;
import xjyb.org.bjca.asn1.x509.X509Name;
import xjyb.org.bjca.asn1.x509.X509NameEntryConverter;
import xjyb.org.bjca.jce.PKCS10CertificationRequest;
import xjyb.org.bjca.jce.fastparser.DerUtil;
import xjyb.org.bjca.jce.valuebean.DeviceKeyPair;

public class P10Util
extends SuperUtil {
    public P10Util(String appName) {
        super(appName);
    }

    public byte[] p10GeneratorByte(String dn, PublicKey pubKey, PrivateKey privateKey) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException {
        X509Name subject = new X509Name(dn);
        PKCS10CertificationRequest p10CertReq = new PKCS10CertificationRequest("SHA1WITHRSA", subject, pubKey, null, privateKey);
        byte[] p10 = p10CertReq.getEncoded();
        return p10;
    }

    public String p10GeneratorString(String dn, PublicKey pubKey, PrivateKey privateKey) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException, Base64Exception {
        Base64Util base64 = new Base64Util(this.applicationName);
        X509Name subject = new X509Name(dn);
        PKCS10CertificationRequest p10CertReq = new PKCS10CertificationRequest("SHA1WITHRSA", subject, pubKey, null, privateKey);
        byte[] p10 = p10CertReq.getEncoded();
        String p10String = base64.BJS_EncodeBase64(p10);
        return p10String;
    }

    public String p10GeneratorString(String alg, String dn, ASN1Set extension, PublicKey pubKey, PrivateKey privateKey) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException, Base64Exception {
        Base64Util base64 = new Base64Util(this.applicationName);
        X509Name subject = new X509Name(dn);
        if ("RSA".equals(alg)) {
            alg = "SHA1WITHRSA";
        }
        PKCS10CertificationRequest p10CertReq = new PKCS10CertificationRequest(alg, subject, pubKey, extension, privateKey);
        byte[] p10 = p10CertReq.getEncoded();
        String p10String = base64.BJS_EncodeBase64(p10);
        return p10String;
    }

    public String p10GeneratorString_sm2(String dn, ASN1Set extension, DeviceKeyPair keyPair) throws Exception {
        WrapCard wc = new WrapCard();
        String p10 = wc.p10GeneratorString_SM2ForDZHT(dn, extension, keyPair);
        return p10;
    }

    public String p10GeneratorStringForJit(String dn, PublicKey pubKey, PrivateKey privateKey) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException, Base64Exception {
        Base64Util base64 = new Base64Util(this.applicationName);
        X509Name subject = new X509Name(true, dn, (X509NameEntryConverter)new X5094JitRSAEntryConverter());
        PKCS10CertificationRequest p10CertReq = new PKCS10CertificationRequest("SHA256WITHRSA", subject, pubKey, null, privateKey);
        byte[] p10 = p10CertReq.getEncoded();
        String p10String = base64.BJS_EncodeBase64(p10);
        return p10String;
    }

    public String p10GeneratorString_sm2(String dn, DeviceKeyPair keyPair) throws Exception {
        WrapCard wc = new WrapCard();
        String p10 = wc.p10GeneratorString_SM2(dn, keyPair);
        return p10;
    }

    public String p10GeneratorString_sm2ForJit(String dn, DeviceKeyPair keyPair) throws Exception {
        WrapCard wc = new WrapCard();
        String p10 = wc.p10GeneratorString_SM2ForJit(dn, keyPair);
        return p10;
    }

    public boolean verifyP10_sm2(byte[] p10) throws Exception {
        DERInputStream derInputStream = new DERInputStream(new ByteArrayInputStream(p10));
        if (derInputStream == null) {
            this.errorlog("in verifyP10_sm2,construct DERInputStream fail");
            return false;
        }
        DERConstructedSequence whole = (DERConstructedSequence)derInputStream.readObject();
        if (whole == null) {
            this.errorlog("in verifyP10_sm2,construct DERConstructedSequence fail");
            return false;
        }
        DERConstructedSequence inDataObj = (DERConstructedSequence)whole.getObjectAt(0);
        if (inDataObj == null) {
            this.errorlog("in verifyP10_sm2,get inDataObject fail");
            return false;
        }
        byte[] inData = inDataObj.getEncoded();
        if (inData == null) {
            this.errorlog("in verifyP10_sm2,get inData fail");
            return false;
        }
        DERConstructedSequence pubKeyObj = (DERConstructedSequence)inDataObj.getObjectAt(2);
        if (pubKeyObj == null) {
            this.errorlog("in verifyP10_sm2,get pubKeyObj fail");
            return false;
        }
        DERBitString pubKeyConstruct = (DERBitString)pubKeyObj.getObjectAt(1);
        if (pubKeyConstruct == null) {
            this.errorlog("in verifyP10_sm2,get pubKeyConstruct fail");
            return false;
        }
        byte[] pubKeyTmp = pubKeyConstruct.getBytes();
        if (pubKeyTmp == null) {
            this.errorlog("in verifyP10_sm2,get pubKeyTmp fail");
            return false;
        }
        byte[] pubKey = new byte[pubKeyTmp.length - 1];
        System.arraycopy(pubKeyTmp, 1, pubKey, 0, pubKeyTmp.length - 1);
        DERBitString signValueBitString = (DERBitString)whole.getObjectAt(2);
        if (signValueBitString == null) {
            this.errorlog("in verifyP10_sm2,get signValueBitString fail");
            return false;
        }
        byte[] signValue = signValueBitString.getBytes();
        if (signValue == null) {
            this.errorlog("in verifyP10_sm2,get signValue fail");
            return false;
        }
        SecurityUtil securityUtil = SecurityUtil.getInstance();
        return securityUtil.verifySignedDataByPubKey(pubKey, inData, signValue);
    }

    public byte[] getP10PublicKey(byte[] p10Der) throws IOException {
        CertificationRequest certReq = new CertificationRequest((ASN1Sequence)DerUtil.writeBytesToDERObj(p10Der));
        SubjectPublicKeyInfo spki = certReq.getCertificationRequestInfo().getSubjectPublicKeyInfo();
        byte[] bPubKey = spki.getPublicKeyData().getBytes();
        return bPubKey;
    }

    public PublicKey getRsaPublicKeyFromP10(byte[] p10Der) throws IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        CertificationRequest certReq = new CertificationRequest((ASN1Sequence)DerUtil.writeBytesToDERObj(p10Der));
        SubjectPublicKeyInfo spki = certReq.getCertificationRequestInfo().getSubjectPublicKeyInfo();
        PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(spki.getEncoded()));
        return publicKey;
    }

    public static void main(String[] args) {
        P10Util p10U = new P10Util("");
        try {
            Base64Util base64Util = new Base64Util("");
            String p10 = "MIHpMIGRAgEAMDExCzAJBgNVBAYTAkNOMQkwBwYDVQQKDAAxCTAHBgNVBAsMADEMMAoGA1UEAwwDc20yMFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAEexes6hiTilQjcAL9hC2rFP7wE0hOIpgX4Gp95kwaAx7M3nY1rsOChNwdy+NYuZFvjGAjM8pW/xLrG5fOmphVrDAKBggqgRzPVQGDdQNHADBEAiD+Cdic4JyNYtXjMSacL6cHB6tvaeYD3ziPK8G3tkU3vAIgWysWFjiTJFeLOpuFR52CerUHz0TmVEwc5+UkiYlLP9M=";
            System.out.println(p10U.verifyP10_sm2(base64Util.BJS_DecodeBase64(p10)));
            FileUtil fileUtil = new FileUtil("");
            byte[] pub = fileUtil.readFile("D:\\2018\u5de5\u4f5c\u76f8\u5173\\\u9879\u76ee\u652f\u6301\\\u652f\u6301SM2p10\\pubAscii.txt");
            byte[] pri = fileUtil.readFile("D:\\2018\u5de5\u4f5c\u76f8\u5173\\\u9879\u76ee\u652f\u6301\\\u652f\u6301SM2p10\\prvAscii.txt");
            DeviceKeyPair dKeyPair = new DeviceKeyPair();
            dKeyPair.setPublicKey(pub);
            dKeyPair.setPrivateKey(pri);
            String dn = "c=cn,cn=zhaosong";
            String p10sm2 = p10U.p10GeneratorString_sm2(dn, dKeyPair);
            System.out.println(p10sm2);
            System.out.println(p10U.verifyP10_sm2(base64Util.BJS_DecodeBase64(p10sm2)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

