/*
 * Decompiled with CFR 0.152.
 */
package xjyb.cn.org.bjca.java.utils.pdf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import xjyb.cn.org.bjca.java.utils.pdf.CertificateUtil;
import xjyb.cn.org.bjca.java.utils.pdf.CrlClient;

public class CrlClientOnline
implements CrlClient {
    protected List<URL> urls = new ArrayList<URL>();

    public CrlClientOnline() {
    }

    public CrlClientOnline(String ... crls) {
        for (String url : crls) {
            try {
                this.urls.add(new URL(url));
                System.out.println("Added CRL url: " + url);
            }
            catch (MalformedURLException e) {
                System.out.println("Skipped CRL url: " + url);
            }
        }
    }

    public CrlClientOnline(URL ... crls) {
        for (URL url : this.urls) {
            this.urls.add(url);
            System.out.println("Added CRL url: " + url);
        }
    }

    public CrlClientOnline(Certificate[] chain) {
        for (int i = 0; i < chain.length; ++i) {
            X509Certificate cert = (X509Certificate)chain[i];
            String url = null;
            try {
                System.out.println("Checking certificate: " + cert.getSubjectDN());
                url = CertificateUtil.getCRLURL(cert);
                if (url == null) continue;
                this.urls.add(new URL(url));
                System.out.println("Added CRL url: " + url);
                continue;
            }
            catch (Exception e) {
                System.out.println("Skipped CRL url: " + url);
            }
        }
    }

    @Override
    public Collection<byte[]> getEncoded(X509Certificate checkCert, String url) {
        if (checkCert == null) {
            return null;
        }
        if (this.urls.size() == 0) {
            System.out.println("Looking for CRL for certificate " + checkCert.getSubjectDN());
            try {
                if (url == null) {
                    url = CertificateUtil.getCRLURL(checkCert);
                }
                if (url == null) {
                    throw new NullPointerException();
                }
                this.urls.add(new URL(url));
                System.out.println("Found CRL url: " + url);
            }
            catch (Exception e) {
                System.out.println("Skipped CRL url: " + e.getMessage());
            }
        }
        ArrayList<byte[]> ar = new ArrayList<byte[]>();
        for (URL urlt : this.urls) {
            try {
                int n;
                System.out.println("Checking CRL: " + urlt);
                HttpURLConnection con = (HttpURLConnection)urlt.openConnection();
                if (con.getResponseCode() / 100 != 2) {
                    throw new IOException("invalid.http.response.? " + con.getResponseCode());
                }
                InputStream inp = (InputStream)con.getContent();
                byte[] buf = new byte[1024];
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                while ((n = inp.read(buf, 0, buf.length)) > 0) {
                    bout.write(buf, 0, n);
                }
                inp.close();
                ar.add(bout.toByteArray());
                System.out.println("Added CRL found at: " + urlt);
            }
            catch (Exception e) {
                System.out.println("Skipped CRL: " + e.getMessage() + " for " + urlt);
            }
        }
        return ar;
    }
}

