/*
 * Decompiled with CFR 0.152.
 */
package xjyb.cn.org.bjca.valuebean;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import xjyb.cn.org.bjca.utils.Base64Util;
import xjyb.org.bjca.asn1.ASN1Encodable;
import xjyb.org.bjca.asn1.ASN1EncodableVector;
import xjyb.org.bjca.asn1.ASN1Sequence;
import xjyb.org.bjca.asn1.DERGeneralizedTime;
import xjyb.org.bjca.asn1.DERObject;
import xjyb.org.bjca.asn1.DEROctetString;
import xjyb.org.bjca.asn1.DERPrintableString;
import xjyb.org.bjca.asn1.DERSequence;
import xjyb.org.bjca.asn1.DERSet;
import xjyb.org.bjca.asn1.DERUTF8String;

public class Copyright
extends ASN1Encodable {
    private DERPrintableString dci;
    private DERUTF8String appName;
    private DERPrintableString version;
    private DERUTF8String author;
    private DERGeneralizedTime developTime;
    private DERGeneralizedTime issueTime;
    private DERGeneralizedTime publicTime;
    private DEROctetString pdfHash;

    public DERPrintableString getDci() {
        return this.dci;
    }

    public void setDci(DERPrintableString dci) {
        this.dci = dci;
    }

    public DERUTF8String getAppName() {
        return this.appName;
    }

    public void setAppName(DERUTF8String appName) {
        this.appName = appName;
    }

    public DERPrintableString getVersion() {
        return this.version;
    }

    public void setVersion(DERPrintableString version) {
        this.version = version;
    }

    public DERUTF8String getAuthor() {
        return this.author;
    }

    public void setAuthor(DERUTF8String author) {
        this.author = author;
    }

    public DERGeneralizedTime getDevelopTime() {
        return this.developTime;
    }

    public void setDevelopTime(DERGeneralizedTime developTime) {
        this.developTime = developTime;
    }

    public DERGeneralizedTime getIssueTime() {
        return this.issueTime;
    }

    public void setIssueTime(DERGeneralizedTime issueTime) {
        this.issueTime = issueTime;
    }

    public DERGeneralizedTime getPublicTime() {
        return this.publicTime;
    }

    public void setPublicTime(DERGeneralizedTime publicTime) {
        this.publicTime = publicTime;
    }

    public Copyright(ASN1Sequence seq) {
        this.dci = (DERPrintableString)seq.getObjectAt(0);
        this.appName = (DERUTF8String)seq.getObjectAt(1);
        this.version = (DERPrintableString)seq.getObjectAt(2);
        this.author = (DERUTF8String)seq.getObjectAt(3);
        this.developTime = (DERGeneralizedTime)seq.getObjectAt(4);
        this.issueTime = (DERGeneralizedTime)seq.getObjectAt(5);
        this.publicTime = (DERGeneralizedTime)seq.getObjectAt(6);
        this.pdfHash = (DEROctetString)seq.getObjectAt(7);
    }

    public Copyright(DERSet set) {
        this.dci = (DERPrintableString)set.getObjectAt(0);
        this.appName = (DERUTF8String)set.getObjectAt(1);
        this.version = (DERPrintableString)set.getObjectAt(2);
        this.author = (DERUTF8String)set.getObjectAt(3);
        this.developTime = (DERGeneralizedTime)set.getObjectAt(4);
        this.issueTime = (DERGeneralizedTime)set.getObjectAt(5);
        this.publicTime = (DERGeneralizedTime)set.getObjectAt(6);
        this.pdfHash = (DEROctetString)set.getObjectAt(7);
    }

    public Copyright(String dciStr, String appNameStr, String versionStr, String authorStr, Date eee, Date eed, Date eev, byte[] pdf) {
        this.dci = new DERPrintableString(dciStr);
        this.appName = new DERUTF8String(appNameStr);
        this.version = new DERPrintableString(versionStr);
        this.author = new DERUTF8String(authorStr);
        this.developTime = new DERGeneralizedTime(eee);
        this.issueTime = new DERGeneralizedTime(eed);
        this.publicTime = new DERGeneralizedTime(eev);
        this.pdfHash = new DEROctetString(pdf);
    }

    public static Copyright getInstance(Object o) {
        if (o instanceof Copyright) {
            return (Copyright)o;
        }
        if (o instanceof ASN1Sequence) {
            return new Copyright((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("Invalid object: " + o.getClass().getName());
    }

    @Override
    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.dci);
        v.add(this.appName);
        v.add(this.version);
        v.add(this.author);
        v.add(this.developTime);
        v.add(this.issueTime);
        v.add(this.publicTime);
        v.add(this.pdfHash);
        return new DERSequence(v);
    }

    public String toASN1ObjectBase64() {
        byte[] en = this.toASN1Object().getDEREncoded();
        Base64Util base64 = new Base64Util("");
        String certRsaBase64 = base64.BJS_EncodeBase64(en);
        return certRsaBase64;
    }

    public String getDevelopTimeString() throws ParseException {
        return this.timeFormat(this.developTime.getTime());
    }

    public String getIssueTimeString() throws ParseException {
        return this.timeFormat(this.issueTime.getTime());
    }

    public String getPublicTimeString() throws ParseException {
        return this.timeFormat(this.publicTime.getTime());
    }

    private String timeFormat(String time) throws ParseException {
        String formateTime = time.substring(0, 14);
        TimeZone defaultTZ = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("Zulu"));
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMddHHmmss");
        Date date = dateformat.parse(formateTime);
        dateformat.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        String conversionTime = dateformat.format(date);
        TimeZone.setDefault(defaultTZ);
        return conversionTime;
    }

    public DEROctetString getPdfHash() {
        return this.pdfHash;
    }

    public void setPdfHash(DEROctetString pdfHash) {
        this.pdfHash = pdfHash;
    }
}

