/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.crypto.agreement;

import java.math.BigInteger;
import xjyb.org.bjca.crypto.BasicAgreement;
import xjyb.org.bjca.crypto.CipherParameters;
import xjyb.org.bjca.crypto.params.AsymmetricKeyParameter;
import xjyb.org.bjca.crypto.params.DHParameters;
import xjyb.org.bjca.crypto.params.DHPrivateKeyParameters;
import xjyb.org.bjca.crypto.params.DHPublicKeyParameters;
import xjyb.org.bjca.crypto.params.ParametersWithRandom;

public class DHBasicAgreement
implements BasicAgreement {
    private DHPrivateKeyParameters key;
    private DHParameters dhParams;

    @Override
    public void init(CipherParameters param) {
        AsymmetricKeyParameter kParam;
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            kParam = (AsymmetricKeyParameter)rParam.getParameters();
        } else {
            kParam = (AsymmetricKeyParameter)param;
        }
        if (!(kParam instanceof DHPrivateKeyParameters)) {
            throw new IllegalArgumentException("DHEngine expects DHPrivateKeyParameters");
        }
        this.key = (DHPrivateKeyParameters)kParam;
        this.dhParams = this.key.getParameters();
    }

    @Override
    public BigInteger calculateAgreement(CipherParameters pubKey) {
        DHPublicKeyParameters pub = (DHPublicKeyParameters)pubKey;
        if (!pub.getParameters().equals(this.dhParams)) {
            throw new IllegalArgumentException("Diffie-Hellman public key has wrong parameters.");
        }
        return pub.getY().modPow(this.key.getX(), this.dhParams.getP());
    }
}

