/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.crypto.generators;

import java.math.BigInteger;
import xjyb.org.bjca.crypto.AsymmetricCipherKeyPair;
import xjyb.org.bjca.crypto.AsymmetricCipherKeyPairGenerator;
import xjyb.org.bjca.crypto.KeyGenerationParameters;
import xjyb.org.bjca.crypto.generators.DHKeyGeneratorHelper;
import xjyb.org.bjca.crypto.params.DHKeyGenerationParameters;
import xjyb.org.bjca.crypto.params.DHParameters;
import xjyb.org.bjca.crypto.params.DHPrivateKeyParameters;
import xjyb.org.bjca.crypto.params.DHPublicKeyParameters;

public class DHKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private DHKeyGeneratorHelper helper = DHKeyGeneratorHelper.INSTANCE;
    private DHKeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (DHKeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        DHParameters dhParams = this.param.getParameters();
        BigInteger p = dhParams.getP();
        BigInteger x = this.helper.calculatePrivate(p, this.param.getRandom(), dhParams.getL());
        BigInteger y = this.helper.calculatePublic(p, dhParams.getG(), x);
        return new AsymmetricCipherKeyPair(new DHPublicKeyParameters(y, dhParams), new DHPrivateKeyParameters(x, dhParams));
    }
}

