/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.crypto.signers;

import java.math.BigInteger;
import java.security.SecureRandom;
import xjyb.org.bjca.crypto.CipherParameters;
import xjyb.org.bjca.crypto.DSA;
import xjyb.org.bjca.crypto.params.ECKeyParameters;
import xjyb.org.bjca.crypto.params.ECPrivateKeyParameters;
import xjyb.org.bjca.crypto.params.ECPublicKeyParameters;
import xjyb.org.bjca.crypto.params.ParametersWithRandom;
import xjyb.org.bjca.math.ec.ECAlgorithms;
import xjyb.org.bjca.math.ec.ECConstants;
import xjyb.org.bjca.math.ec.ECPoint;

public class ECDSASigner
implements ECConstants,
DSA {
    ECKeyParameters key;
    SecureRandom random;

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.random = rParam.getRandom();
                this.key = (ECPrivateKeyParameters)rParam.getParameters();
            } else {
                this.random = new SecureRandom();
                this.key = (ECPrivateKeyParameters)param;
            }
        } else {
            this.key = (ECPublicKeyParameters)param;
        }
    }

    @Override
    public BigInteger[] generateSignature(byte[] message) {
        BigInteger d;
        BigInteger k;
        BigInteger n = this.key.getParameters().getN();
        BigInteger e = this.calculateE(n, message);
        BigInteger r = null;
        BigInteger s = null;
        do {
            ECPoint p;
            BigInteger x;
            k = null;
            int nBitLength = n.bitLength();
            while ((k = new BigInteger(nBitLength, this.random)).equals(ZERO) || (r = (x = (p = this.key.getParameters().getG().multiply(k)).getX().toBigInteger()).mod(n)).equals(ZERO)) {
            }
            d = ((ECPrivateKeyParameters)this.key).getD();
        } while ((s = k.modInverse(n).multiply(e.add(d.multiply(r))).mod(n)).equals(ZERO));
        BigInteger[] res = new BigInteger[]{r, s};
        return res;
    }

    @Override
    public boolean verifySignature(byte[] message, BigInteger r, BigInteger s) {
        BigInteger n = this.key.getParameters().getN();
        BigInteger e = this.calculateE(n, message);
        if (r.compareTo(ONE) < 0 || r.compareTo(n) >= 0) {
            return false;
        }
        if (s.compareTo(ONE) < 0 || s.compareTo(n) >= 0) {
            return false;
        }
        BigInteger c = s.modInverse(n);
        BigInteger u1 = e.multiply(c).mod(n);
        BigInteger u2 = r.multiply(c).mod(n);
        ECPoint G = this.key.getParameters().getG();
        ECPoint Q = ((ECPublicKeyParameters)this.key).getQ();
        ECPoint point = ECAlgorithms.sumOfTwoMultiplies(G, u1, Q, u2);
        BigInteger v = point.getX().toBigInteger().mod(n);
        return v.equals(r);
    }

    private BigInteger calculateE(BigInteger n, byte[] message) {
        if (n.bitLength() > message.length * 8) {
            return new BigInteger(1, message);
        }
        int messageBitLength = message.length * 8;
        BigInteger trunc = new BigInteger(1, message);
        if (messageBitLength - n.bitLength() > 0) {
            trunc = trunc.shiftRight(messageBitLength - n.bitLength());
        }
        return trunc;
    }
}

