/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.jce.fastparser;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import xjyb.org.bjca.jce.fastparser.DerUtil;
import xjyb.org.bjca.jce.fastparser.EncryptedContentInfo;
import xjyb.org.bjca.jce.fastparser.EnvelopedData;
import xjyb.org.bjca.jce.fastparser.FastPkcs7;
import xjyb.org.bjca.jce.fastparser.IssuerAndSerialNumber;
import xjyb.org.bjca.jce.fastparser.RecipientInfo;

public class Pkcs7Test {
    public static final String p7t = "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";
    public static final String samplep7 = "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";
    public static final String asp7 = "MIIDlwYJKoZIhvcNAQcCoIIDiDCCA4QCAQExCzAJBgUrDgMCGgUAMBAGCSqGSIb3DQEHAaADBAExoIICejCCAnYwggHfoAMCAQICBEBNACMwDQYJKoZIhvcNAQEFBQAwNDERMA8GA1UEAxMIcm9vdDEwMTkxDTALBgNVBAsTBHRlc3QxEDAOBgNVBAoTB2luZm9zZWMwHhcNMDUxMDIwMDUxMTI5WhcNMDgxMDIwMDUxMTI5WjAiMQ4wDAYDVQQDEwUzeWVhcjEQMA4GA1UEChMHaW5mb3NlYzCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAtmQc4ixZh2Espo6n1+B2dnd/xx/oDog6Ys3ns3if30hpPnO+lEHEyyNoKlLcL+aGC95JcVETkZBLndnED2PNPCwuj47WJ9kkfN5RCZ09inb5kr4U8RBlB1y+qkzs2F120Bq3+GSHyhlvZR7OhmdMRpIPxvY98YXryJaPWK8lfvcCAwEAAaOBpjCBozAfBgNVHSMEGDAWgBSCYTUfVp3rjQgJUJkqCv7vDfoO/TBCBgNVHR8EOzA5MDegNaAzpDEwLzENMAsGA1UEAxMEY3JsMTEMMAoGA1UECxMDY3JsMRAwDgYDVQQKEwdpbmZvc2VjMB0GA1UdDgQWBBQtRRY+Bch2O9rzc0XKcA/JT1n/7zAdBgNVHSUEFjAUBggrBgEFBQcDAQYIKwYBBQUHAwgwDQYJKoZIhvcNAQEFBQADgYEAmHbul3RqUdK3LRQmzsmFm/Q1ODjKQZDWlU7ZWBvWNZy4hywXqbDYtvKi3dSWPRIm9ZsiYRxLP/kBX49p1b1+nOKaJBZwMX4546nnRbZ6nXnFwbxS1pcQ9yJSOMlAn/5fy3QcgjyPhofSxENxFfbNtFpgsMB1pCDWLn9HLa093qkxgeEwgd4CAQEwPDA0MREwDwYDVQQDEwhyb290MTAxOTENMAsGA1UECxMEdGVzdDEQMA4GA1UEChMHaW5mb3NlYwIEQE0AIzAJBgUrDgMCGgUAMA0GCSqGSIb3DQEBAQUABIGAQ12FQpQ9sdiZZcKbH1RbO/PghxdUwJ5mUclTTsA5ZbCr7bQWFcMwA4QusaDpulZippflnAJibxb0cu23c0SK0/2yXIRcb6L8nRVZT7AQXZMVEt6ojbqdWqE3JaZIjHbszcEv0AJgDb+gIbimFeVRI4BartVjUiaLk+V2X3FhabE=";
    public static final String dsp7 = "MIIDkgYJKoZIhvcNAQcCoIIDgzCCA38CAQExCzAJBgUrDgMCGgUAMAsGCSqGSIb3DQEHAaCCAnowggJ2MIIB36ADAgECAgRATQAjMA0GCSqGSIb3DQEBBQUAMDQxETAPBgNVBAMTCHJvb3QxMDE5MQ0wCwYDVQQLEwR0ZXN0MRAwDgYDVQQKEwdpbmZvc2VjMB4XDTA1MTAyMDA1MTEyOVoXDTA4MTAyMDA1MTEyOVowIjEOMAwGA1UEAxMFM3llYXIxEDAOBgNVBAoTB2luZm9zZWMwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBALZkHOIsWYdhLKaOp9fgdnZ3f8cf6A6IOmLN57N4n99IaT5zvpRBxMsjaCpS3C/mhgveSXFRE5GQS53ZxA9jzTwsLo+O1ifZJHzeUQmdPYp2+ZK+FPEQZQdcvqpM7NhddtAat/hkh8oZb2UezoZnTEaSD8b2PfGF68iWj1ivJX73AgMBAAGjgaYwgaMwHwYDVR0jBBgwFoAUgmE1H1ad640ICVCZKgr+7w36Dv0wQgYDVR0fBDswOTA3oDWgM6QxMC8xDTALBgNVBAMTBGNybDExDDAKBgNVBAsTA2NybDEQMA4GA1UEChMHaW5mb3NlYzAdBgNVHQ4EFgQULUUWPgXIdjva83NFynAPyU9Z/+8wHQYDVR0lBBYwFAYIKwYBBQUHAwEGCCsGAQUFBwMIMA0GCSqGSIb3DQEBBQUAA4GBAJh27pd0alHSty0UJs7JhZv0NTg4ykGQ1pVO2Vgb1jWcuIcsF6mw2Lbyot3Ulj0SJvWbImEcSz/5AV+PadW9fpzimiQWcDF+OeOp50W2ep15xcG8UtaXEPciUjjJQJ/+X8t0HII8j4aH0sRDcRX2zbRaYLDAdaQg1i5/Ry2tPd6pMYHhMIHeAgEBMDwwNDERMA8GA1UEAxMIcm9vdDEwMTkxDTALBgNVBAsTBHRlc3QxEDAOBgNVBAoTB2luZm9zZWMCBEBNACMwCQYFKw4DAhoFADANBgkqhkiG9w0BAQEFAASBgENdhUKUPbHYmWXCmx9UWzvz4IcXVMCeZlHJU07AOWWwq+20FhXDMAOELrGg6bpWYqaX5ZwCYm8W9HLtt3NEitP9slyEXG+i/J0VWU+wEF2TFRLeqI26nVqhNyWmSIx27M3BL9ACYA2/oCG4phXlUSOAWq7VY1Imi5Pldl9xYWmx";
    public static final String esp7 = "MIIEqwYJKoZIhvcNAQcDoIIEnDCCBJgCAQAxgdYwgdMCAQAwPDA0MREwDwYDVQQDEwhyb290MTAxOTENMAsGA1UECxMEdGVzdDEQMA4GA1UEChMHaW5mb3NlYwIEQE0AATANBgkqhkiG9w0BAQEFAASBgGP73OHFTAIGt4IWfmH3fdABVTuuM/+3Xu+KNVCKaRnV7wV3yB3zNjZ8mOEEeHm4dfr2LbbdTeBqq7gK5HpKqO6CeuCXLsyuCcj2ir5S2677mxMYf2J7jHl7BLg28eVLkTd9YkhRYaG/WJSO8lwNiLjbzttBuOityrUW4l8WqlXZMIIDuAYJKoZIhvcNAQcBMAwGCCqGSIb3DQMEBQCAggObawqrN2T+dAp0JpDYDcXIqVeFh5DXFZaKmeUp4vYEb6NRv0KwiCsIfcTLtOapxVrA0lq1fu7zqsi9VflU49a+iIEr6I+FZb0rMGrQBeEia2/Rc9qwA+Y6vncjCdQe+UmfunapjIaAIfGvHaGzUUD9YgYBhnVBIL3em9mzZ18oFrvvEZ+IF1QkR+IPnmGZBjL1BaEonW3y5HnImNB9BsNMw30d1fS+zfd0FpUtAS0030q1H9i+OjWfoiQjvyY1Ctn1eQ41snSP8CTQwjw7Ff/6YKQhzgQpQJPEhwip9yb4dT2YyDYpD53qJl7VXVLrPqOc7Fe6HX8RBUWHu+T/1EupQOLJfJ6XAIdYp7aoCQt6W/X7tcJV1NwxKEVhzMDaZn+KxLgw+0bNQU658qqN92eqVXA8F+7tTP+lJ1SigQU+0kg+Szn75zu9AB0JVKssk5ms48R4p6tBDvyp3gmRQK7HEp2nuCulEUBe+xLXFpaJuf8wjJtwBUpDEJV+oJibaQiYWz53NAKGjbewPv1I+pln71EDZFW0wLbXIJKAdZyhSEvsBnfRLyi6io11QO1Cj0ts4omI3XDEjGrY8r2U4tK7mCzYV0oQMaN+9I12Vnzfv43OruIukdpNLF2/a/Ylk6Y8lPX2yVY2KA1Q5QMp2mxFlZsQP143aF+hZlvDMbl+H7maKbpjJ0JhxAqBWDgaIuo/EDa1uwt4ZypHtUrF2pj5j3eba5TdxL+CPVo93orvO2gPSy3Dd3u+JJYHt08U6A04zl8eJ/WDGq8U16K8mb0RcpwMarM7JAoOib4DxYhr6RqH58y6ahF6srrLlVRJegZW/8Jb8nMBjwdzy2+fiYpd6351lTaU8kKh1nJpnOXZJTYP2SuFCeDk+XmRq8icrgo92SOGKD4Gadz4mNJI1368UrOG+1eCz8MAU++nPwQYis0Hyw5JUGZh3ZWQXUBxpFTEUtmFoehx8qXj+61eA5NG5hHt4XcB8p++In2gITbT18JE22TsfGCJuJ3/fYtIS+pcswZTCAv/Sv6F7QL80DFab8Ru7wQJ8gB3dqGbszLsrRxv2Q8GVsvEKZ0e0RsOtJbBf6nf5Ev669ExM3vPMs6LmnqE2pD+Sf0zU+hqDm/ZDzHJhJ5L8CKc320JNA3gbd8LzLXRFS+vcHbarhj+Ov12ZeOnYPlhMbxjIRV248qzU78QDiMdtP6Alxw/Ruv+AeCj2fwJlxS2X/PrgCs=";
    public static final String ccp7 = "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";
    public static final String envelopp7 = "MIIBDQYJKoZIhvcNAQcDoIH/MIH8AgEAMYHWMIHTAgEAMDwwNDERMA8GA1UEAxMIcm9vdDEwMTkxDTALBgNVBAsTBHRlc3QxEDAOBgNVBAoTB2luZm9zZWMCBEBNACMwDQYJKoZIhvcNAQEBBQAEgYAQdQvYx6gEVob8P2x4Vj5pLk+JNoRhmp4k3HZX36oaDMkIhBkkmOwO29vGZX590S8B0TXrrULqYa/mOvkaEqcmYJfS0hoPv7ulamxs/C90FMil+dZs7vired3UBg08BWeQvdbh71OA8hQ5oC1QsHT5SHFLSUq8JBKWWAyTxnRhLDAeBgkqhkiG9w0BBwEwDAYIKoZIhvcNAwQFAKADBAHd";
    public static final String signedAndEnvelopep7 = "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";

    public static void genp7(String ofname, byte[] p7bytes) {
        try {
            FileOutputStream fos = new FileOutputStream(new File(ofname));
            FastPkcs7 fp = new FastPkcs7();
            fos.write(fp.getPkcs7(p7bytes));
            fos.close();
            System.out.println("end!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        FastPkcs7 fp = new FastPkcs7();
        int length = fp.getPkcs7("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".getBytes()).length;
        byte[] source = new byte[length];
        System.arraycopy(fp.getPkcs7("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".getBytes()), 0, source, 0, length);
        int count = 1;
        long start = System.currentTimeMillis();
        for (int i = 0; i < count; ++i) {
            fp.pkcs7Data(source);
            ArrayList ecert = fp.getCerts();
            System.out.println("DigestAlgorithm=" + fp.getDigestAlgorithm());
            System.out.println("DigestEncryptionAlgorithm=" + fp.getDigestEncryptionAlgorithm());
            System.out.println("Signing Certificate:" + fp.getSignCert());
            if (fp.getSignCert().length > 0) {
                try {
                    CertificateFactory cf = CertificateFactory.getInstance("X509");
                    BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(source, fp.getSignCert().offset, fp.getSignCert().length));
                    X509Certificate cert = (X509Certificate)cf.generateCertificate(bis);
                    System.out.println("Signing PublicKey: " + cert.getPublicKey().getFormat() + "\nPublic Key:" + cert.getPublicKey() + "\nIssuer=" + cert.getIssuerDN());
                    bis.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (fp.getContentType() != 3) continue;
            EnvelopedData ed = fp.getEnvelopedData();
            EncryptedContentInfo eci = ed.getEncryptedContentInfoObject();
            System.out.println("EncryptedContentInfo : " + eci.getCt() + "\nContentEncryptionAlgorithm : " + DerUtil.toDERObjectIdentifier(source, eci.getContentEncryptionAlgorithm().offset, eci.getContentEncryptionAlgorithm().length) + "\n" + eci.getContentEncryptionAlgorithm() + "\nEncryptedContent : " + eci.getEncryptedContent());
            DerUtil.printItem(source, eci.getEncryptedContent());
            ArrayList ari = ed.getVRecipientInfo();
            for (int j = 0; j < ari.size(); ++j) {
                RecipientInfo ri = (RecipientInfo)ari.get(j);
                System.out.println("IssuerAndSerialNumber: " + ri.getIssuerAndSerialNumber());
                IssuerAndSerialNumber iasn = new IssuerAndSerialNumber(source, ri.getIssuerAndSerialNumber());
                System.out.println("Issuer:");
                DerUtil.printItem(source, iasn.getIssuer());
                DerUtil.printItem(source, ri.getIssuerAndSerialNumber());
                System.out.println(ri.getEncryptedKey());
                System.out.println(ri.getKeyEncryptionAlgorithm());
                if (ri.getIvParameter() != null) {
                    System.out.println("Iv is ");
                    DerUtil.printBytes(ri.getIvParameter(), 0, ri.getIvParameter().length, 16);
                }
                System.out.println("AlgorithmIdentifier is " + ri.getEncryptedAlgorithmIdenfitier());
                System.out.println("Encryption Key is ");
                DerUtil.printBytes(ri.getEncKey(), 0, ri.getEncKey().length, 16);
            }
        }
        long end = System.currentTimeMillis();
        System.out.println("parsed " + count + " PKCS#7 package spaned " + (end - start));
    }
}

