/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.jce.fastparser;

import xjyb.org.bjca.jce.fastparser.DerUtil;
import xjyb.org.bjca.jce.fastparser.Item;

public class RawData {
    private byte[] data = null;
    private Item rawData = new Item();

    public RawData(byte[] input, Item it) {
        this.parse(input, it.offset, it.length);
    }

    private void parse(byte[] input, int offset, int length) {
        if (DerUtil.debug) {
            System.out.println("Entering RawData Parse @ (" + Integer.toHexString(offset) + "," + length + ")");
            DerUtil.printBytes(input, offset, length, 16);
        }
        if (length < 2) {
            return;
        }
        DerUtil.computeOffset(input, this.rawData, offset, 0);
        this.rawData.offset += offset;
        if (this.rawData.length > 0) {
            this.data = new byte[this.rawData.length];
            System.arraycopy(input, this.rawData.offset, this.data, 0, this.rawData.length);
            if (DerUtil.debug) {
                System.out.println("Data @ RawData Class:");
                DerUtil.printBytes(this.data, 0, this.data.length, 16);
            }
        } else {
            this.rawData = new Item();
        }
    }

    public byte[] getData() {
        if (this.data != null) {
            return this.data;
        }
        return new byte[0];
    }

    public Item getRawData() {
        return this.rawData;
    }

    public void getRawData(byte[] input, Item rdItem, byte[] dst) {
        if (rdItem.length > 0 && rdItem.offset + rdItem.length <= input.length) {
            dst = new byte[rdItem.length];
            System.arraycopy(input, rdItem.offset, dst, 0, rdItem.length);
        }
    }
}

