/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.jce.fastparser;

import java.util.Vector;
import xjyb.org.bjca.jce.fastparser.DerUtil;
import xjyb.org.bjca.jce.fastparser.EncryptedContentInfo;
import xjyb.org.bjca.jce.fastparser.Item;
import xjyb.org.bjca.jce.fastparser.RecipientInfo;

public class SignedAndEnvelopedData {
    private int version;
    private Item recipientInfos = new Item();
    private Item digestAlgorithms = new Item();
    private Item encryptedContentInfo = new Item();
    private Item certificates = new Item();
    private Item crls = new Item();
    private Item signerInfos = new Item();
    private EncryptedContentInfo oEncryptedContentInfo = new EncryptedContentInfo();
    private Vector vRecipientInfo = new Vector(1);

    public SignedAndEnvelopedData() {
    }

    public SignedAndEnvelopedData(byte[] input, Item it) {
        this.parse(input, it.offset, it.length);
    }

    public void parse(byte[] input, int offset, int length) {
        int position = 0;
        Item tmpitem = new Item();
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset;
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset + tmpitem.length;
        tmpitem.offset += offset;
        this.version = DerUtil.toInt(input, tmpitem.offset, tmpitem.length);
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset + tmpitem.length;
        tmpitem.offset += offset;
        this.recipientInfos = new Item(tmpitem);
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset + tmpitem.length;
        tmpitem.offset += offset;
        this.digestAlgorithms = new Item(tmpitem);
        DerUtil.computeOffset(input, tmpitem, offset, position);
        tmpitem.offset += offset;
        this.encryptedContentInfo = new Item(tmpitem);
        for (int i = 0; position < length && i < 2; ++i) {
            int option = input[offset + position] & 0xF;
            DerUtil.computeOffset(input, tmpitem, offset, position);
            switch (option) {
                case 0: 
                case 2: {
                    this.certificates = new Item(tmpitem);
                    this.certificates.offset = position + offset;
                    break;
                }
                case 1: 
                case 3: {
                    this.crls = new Item(tmpitem);
                    this.crls.offset = position + offset;
                    break;
                }
            }
            position = tmpitem.offset + tmpitem.length;
        }
        if (position < length && (input[offset + position] & 0xA0) != 160) {
            DerUtil.computeOffset(input, tmpitem, offset, position);
            this.signerInfos = new Item(tmpitem);
            this.signerInfos.offset += offset;
        }
        this.oEncryptedContentInfo.parse(input, this.encryptedContentInfo.offset, this.encryptedContentInfo.length);
        position = 0;
        while (position < this.recipientInfos.length) {
            DerUtil.computeOffset(input, tmpitem, this.recipientInfos.offset, position);
            position = tmpitem.offset + tmpitem.length;
            tmpitem.offset += this.recipientInfos.offset;
            RecipientInfo ri = new RecipientInfo();
            ri.parse(input, tmpitem.offset, tmpitem.length);
            this.vRecipientInfo.add(ri);
        }
    }

    public final Item getCertificates() {
        return this.certificates;
    }

    public final Item getCrls() {
        return this.crls;
    }

    public final Item getSignerInfos() {
        return this.signerInfos;
    }

    public final EncryptedContentInfo getEncryptedContentInfo() {
        return this.oEncryptedContentInfo;
    }

    public final Vector getRecipientInfo() {
        return this.vRecipientInfo;
    }

    public Item getDigestAlgorithms() {
        return this.digestAlgorithms;
    }

    public int getVersion() {
        return this.version;
    }
}

