/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.SecretKeySpec;
import xjyb.org.bjca.jce.provider.BouncyCastleProvider;
import xjyb.org.bjca.jce.provider.test.BaseBlockCipherTest;
import xjyb.org.bjca.util.encoders.Hex;

public class NoekeonTest
extends BaseBlockCipherTest {
    static String[] cipherTests = new String[]{"128", "b1656851699e29fa24b70148503d2dfc", "2a78421b87c7d0924f26113f1d1349b2", "e2f687e07b75660ffc372233bc47532c"};

    public NoekeonTest() {
        super("Noekeon");
    }

    public void test(int strength, byte[] keyBytes, byte[] input, byte[] output) throws Exception {
        SecretKeySpec key = new SecretKeySpec(keyBytes, "Noekeon");
        Cipher in = Cipher.getInstance("Noekeon/ECB/NoPadding", "BC");
        Cipher out = Cipher.getInstance("Noekeon/ECB/NoPadding", "BC");
        try {
            out.init(1, key);
        }
        catch (Exception e) {
            this.fail("Noekeon failed initialisation - " + e.toString(), e);
        }
        try {
            in.init(2, key);
        }
        catch (Exception e) {
            this.fail("Noekeoen failed initialisation - " + e.toString(), e);
        }
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        CipherOutputStream cOut = new CipherOutputStream(bOut, out);
        try {
            for (int i = 0; i != input.length / 2; ++i) {
                cOut.write(input[i]);
            }
            cOut.write(input, input.length / 2, input.length - input.length / 2);
            cOut.close();
        }
        catch (IOException e) {
            this.fail("Noekeon failed encryption - " + e.toString(), e);
        }
        byte[] bytes = bOut.toByteArray();
        if (!this.areEqual(bytes, output)) {
            this.fail("Noekeon failed encryption - expected " + new String(Hex.encode(output)) + " got " + new String(Hex.encode(bytes)));
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(bytes);
        CipherInputStream cIn = new CipherInputStream(bIn, in);
        try {
            DataInputStream dIn = new DataInputStream(cIn);
            bytes = new byte[input.length];
            for (int i = 0; i != input.length / 2; ++i) {
                bytes[i] = (byte)dIn.read();
            }
            dIn.readFully(bytes, input.length / 2, bytes.length - input.length / 2);
        }
        catch (Exception e) {
            this.fail("Noekeon failed encryption - " + e.toString(), e);
        }
        if (!this.areEqual(bytes, input)) {
            this.fail("Noekeon failed decryption - expected " + new String(Hex.encode(input)) + " got " + new String(Hex.encode(bytes)));
        }
    }

    @Override
    public void performTest() throws Exception {
        for (int i = 0; i != cipherTests.length; i += 4) {
            this.test(Integer.parseInt(cipherTests[i]), Hex.decode(cipherTests[i + 1]), Hex.decode(cipherTests[i + 2]), Hex.decode(cipherTests[i + 3]));
        }
    }

    public static void main(String[] args) {
        Security.addProvider(new BouncyCastleProvider());
        NoekeonTest.runTest(new NoekeonTest());
    }
}

