/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.sm4soft.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import sun.misc.HexDumpEncoder;

public class ByteUtil {
    public static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final String delimiter = "";

    public static int bytes2int(byte[] bytes) {
        int num = 0;
        for (int i = 0; i < 4; ++i) {
            num += (0xFF & bytes[3 - i]) << i * 8;
        }
        return num;
    }

    public static byte[] long2bytes(long num) {
        byte[] bytes = new byte[8];
        for (int i = 0; i < 8; ++i) {
            bytes[7 - i] = (byte)(0xFFL & num >> i * 8);
        }
        return bytes;
    }

    public static byte[] int2bytes(int num) {
        byte[] bytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            bytes[3 - i] = (byte)(0xFF & num >> i * 8);
        }
        return bytes;
    }

    public static byte[] reverse(byte[] input) {
        byte[] output = new byte[input.length];
        for (int i = 0; i < input.length; ++i) {
            output[i] = input[input.length - 1 - i];
        }
        return output;
    }

    public static byte[] catbytes(byte[] bytes1, byte[] bytes2) {
        byte[] out = new byte[bytes1.length + bytes2.length];
        System.arraycopy(bytes1, 0, out, 0, bytes1.length);
        System.arraycopy(bytes2, 0, out, bytes1.length, bytes2.length);
        return out;
    }

    public static byte[] subbytes(byte[] bytes, int offset, int length) {
        byte[] buf = new byte[length];
        System.arraycopy(bytes, offset, buf, 0, length);
        return buf;
    }

    public static String bytes2hex(byte[] bytes) {
        return ByteUtil.bytes2hex(bytes, delimiter, bytes.length + 1);
    }

    public static byte[] hex2bytes(String str) {
        return ByteUtil.hex2bytes(str, delimiter);
    }

    private static byte[] hex2bytes(String str, String delimiter) {
        str = str.toLowerCase();
        if (delimiter.equals(delimiter)) {
            byte[] buf = new byte[str.length() / 2];
            for (int i = 0; i < buf.length; ++i) {
                char ch = str.charAt(i * 2);
                buf[i] = ch >= 'a' && ch <= 'f' ? (byte)(ch - 97 + 10 << 4) : (byte)(ch - 48 << 4);
                ch = str.charAt(i * 2 + 1);
                if (ch >= 'a' && ch <= 'f') {
                    int n = i;
                    buf[n] = (byte)(buf[n] + (byte)(ch - 97 + 10));
                    continue;
                }
                int n = i;
                buf[n] = (byte)(buf[n] + (byte)(ch - 48));
            }
            return buf;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        String[] arr = str.split(delimiter);
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i].trim().equals(delimiter)) continue;
            baos.write(ByteUtil.hex2byte(arr[i]));
        }
        return baos.toByteArray();
    }

    public static String byte2hex(byte n) {
        String str = delimiter;
        str = str + HEX[(n & 0xF0) >> 4];
        str = str + HEX[n & 0xF];
        return str;
    }

    public static byte hex2byte(String str) {
        char ch = str.charAt(0);
        byte n = ch >= 'a' && ch <= 'f' ? (byte)(ch - 97 + 10 << 4) : (byte)(ch - 48 << 4);
        ch = str.charAt(1);
        n = ch >= 'a' && ch <= 'f' ? (byte)(n + (byte)(ch - 97 + 10)) : (byte)(n + (byte)(ch - 48));
        return n;
    }

    private static String bytes2hex(byte[] data, String delimiter, int wrap) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            if (i != 0 && i % wrap == 0) {
                sb.append("\n");
            }
            sb.append(ByteUtil.byte2hex(data[i]));
            sb.append(delimiter);
        }
        sb.append(", " + data.length);
        return sb.toString();
    }

    public static void printHex(byte[] bytes) {
        ByteUtil.printHex(bytes, 16);
    }

    private static void printHex(byte[] bytes, int wrap) {
        for (int i = 0; i < bytes.length; i += wrap) {
            if (i % 16 == 0) {
                if (i != 0) {
                    System.out.println();
                }
                System.out.printf("%08X  ", i);
            }
            int j = i;
            while (j < i + wrap & j < bytes.length) {
                if (j - i == wrap / 2) {
                    System.out.printf(" ", new Object[0]);
                }
                System.out.printf("%02X ", bytes[j]);
                ++j;
            }
        }
        System.out.println();
    }

    public static void main(String[] args) {
        byte[] data = "asadafadsfewqf1312214r132rfwefwqt4q3tqwrefqew4r".getBytes();
        data = new byte[32];
        new Random().nextBytes(data);
        System.out.println(new String(data));
        System.out.println(ByteUtil.bytes2hex(data));
        byte[] data1 = ByteUtil.hex2bytes(ByteUtil.bytes2hex(data));
        System.out.println(new String(data1));
        new Random().nextBytes(data);
        HexDumpEncoder d = new HexDumpEncoder();
        try {
            d.encode(data, (OutputStream)System.out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

