/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.x509.extension;

import java.io.IOException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import xjyb.org.bjca.asn1.ASN1Object;
import xjyb.org.bjca.asn1.ASN1OctetString;
import xjyb.org.bjca.asn1.DERObjectIdentifier;
import xjyb.org.bjca.asn1.DEROctetString;
import xjyb.org.bjca.asn1.DERSequence;
import xjyb.org.bjca.asn1.DERString;
import xjyb.org.bjca.asn1.x509.GeneralName;
import xjyb.org.bjca.asn1.x509.X509Extensions;
import xjyb.org.bjca.asn1.x509.X509Name;

public class X509ExtensionUtil {
    public static ASN1Object fromExtensionValue(byte[] encodedValue) throws IOException {
        ASN1OctetString octs = (ASN1OctetString)ASN1Object.fromByteArray(encodedValue);
        return ASN1Object.fromByteArray(octs.getOctets());
    }

    public static Collection getIssuerAlternativeNames(X509Certificate cert) throws CertificateParsingException {
        byte[] extVal = cert.getExtensionValue(X509Extensions.IssuerAlternativeName.getId());
        return X509ExtensionUtil.getAlternativeName(extVal);
    }

    public static Collection getSubjectAlternativeNames(X509Certificate cert) throws CertificateParsingException {
        byte[] extVal = cert.getExtensionValue(X509Extensions.SubjectAlternativeName.getId());
        return X509ExtensionUtil.getAlternativeName(extVal);
    }

    private static Collection getAlternativeName(byte[] extVal) throws CertificateParsingException {
        ArrayList temp = new ArrayList();
        if (extVal == null) {
            return Collections.EMPTY_LIST;
        }
        try {
            byte[] extnValue = DEROctetString.getInstance(ASN1Object.fromByteArray(extVal)).getOctets();
            Enumeration it = DERSequence.getInstance(ASN1Object.fromByteArray(extnValue)).getObjects();
            while (it.hasMoreElements()) {
                GeneralName genName = GeneralName.getInstance(it.nextElement());
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(new Integer(genName.getTagNo()));
                switch (genName.getTagNo()) {
                    case 0: 
                    case 3: 
                    case 5: {
                        list.add(genName.getName().getDERObject());
                        break;
                    }
                    case 4: {
                        list.add(X509Name.getInstance(genName.getName()).toString());
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 6: {
                        list.add(((DERString)((Object)genName.getName())).getString());
                        break;
                    }
                    case 8: {
                        list.add(DERObjectIdentifier.getInstance(genName.getName()).getId());
                        break;
                    }
                    case 7: {
                        list.add(DEROctetString.getInstance(genName.getName()).getOctets());
                        break;
                    }
                    default: {
                        throw new IOException("Bad tag number: " + genName.getTagNo());
                    }
                }
                temp.add(list);
            }
        }
        catch (Exception e) {
            throw new CertificateParsingException(e.getMessage());
        }
        return Collections.unmodifiableCollection(temp);
    }
}

