/*
 * Decompiled with CFR 0.152.
 */
package cn.com.szhtkj.tools;

import cn.hutool.core.util.StrUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;

public class PropTool {
    public static HashMap<String, Properties> propFileMap = null;

    public static Properties getPropObject(String propFileName) {
        if (propFileMap == null || !propFileMap.containsKey(propFileName)) {
            PropTool.initFileMap(propFileName);
        }
        return propFileMap.get(propFileName);
    }

    public static String getPropValue(String propFilename, String key) {
        return PropTool.getPropValue(propFilename, key, "");
    }

    public static String getPropValue(String propFilename, String key, String defValue) {
        Properties propObject = PropTool.getPropObject(propFilename);
        if (propObject == null) {
            return defValue;
        }
        String retValue = propObject.getProperty(key);
        if (!StrUtil.isBlank((CharSequence)retValue)) {
            return retValue;
        }
        return defValue;
    }

    public static synchronized void initFileMap(String fileName) {
        if (StrUtil.isBlank((CharSequence)fileName)) {
            return;
        }
        Properties properties = new Properties();
        InputStream in = PropTool.class.getClassLoader().getResourceAsStream(fileName + ".properties");
        try {
            properties.load(in);
            if (propFileMap == null) {
                propFileMap = new HashMap();
            }
            propFileMap.put(fileName, properties);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

