/*
 * Decompiled with CFR 0.152.
 */
package cn.com.szhtkj.tools;

import api.info.QRCodeInfo;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.qrcode.BufferedImageLuminanceSource;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.NotFoundException;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.QRCodeReader;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;

public class QRCodeTool {
    public static BufferedImage zoomInImage(BufferedImage originalImage, Integer times) {
        int width = originalImage.getWidth() * times;
        int height = originalImage.getHeight() * times;
        BufferedImage newImage = new BufferedImage(width, height, originalImage.getType());
        Graphics g = newImage.getGraphics();
        g.drawImage(originalImage, 0, 0, width, height, null);
        g.dispose();
        return newImage;
    }

    public static String extractImages(BufferedImage image) throws IOException {
        String returnResult = "";
        BinaryBitmap binaryBitmap = null;
        Result result = null;
        try {
            BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
            HybridBinarizer binarizer = new HybridBinarizer((LuminanceSource)source);
            binaryBitmap = new BinaryBitmap((Binarizer)binarizer);
            HashMap<DecodeHintType, Object> hints = new HashMap<DecodeHintType, Object>();
            hints.put(DecodeHintType.CHARACTER_SET, "UTF-8");
            hints.put(DecodeHintType.TRY_HARDER, Boolean.TRUE);
            hints.put(DecodeHintType.PURE_BARCODE, Boolean.TYPE);
            result = new MultiFormatReader().decode(binaryBitmap, hints);
            returnResult = result.getText();
        }
        catch (NotFoundException e) {
            QRCodeReader reader = new QRCodeReader();
            try {
                result = reader.decode(binaryBitmap);
                returnResult = result.getText();
            }
            catch (ReaderException e1) {
                e1.printStackTrace();
            }
        }
        return returnResult;
    }

    public static QRCodeInfo getQRCodeInfo(String qrInfo) {
        if (StrUtil.isBlank((CharSequence)qrInfo) || qrInfo.contains("shenzhen.chinatax.gov.cn")) {
            return null;
        }
        QRCodeInfo qrCodeInfo = null;
        String[] qrInfoArr = qrInfo.split(",");
        if (qrInfoArr.length >= 6) {
            if ("10".equals(qrInfoArr[1]) || "20".equals(qrInfoArr[1]) || "31".equals(qrInfoArr[1]) || "32".equals(qrInfoArr[1])) {
                qrCodeInfo = new QRCodeInfo();
                qrCodeInfo.setTaxBureau(qrInfoArr[0]);
                qrCodeInfo.setKind(qrInfoArr[1]);
                qrCodeInfo.setCode(qrInfoArr[2]);
                qrCodeInfo.setNumber(qrInfoArr[3]);
                qrCodeInfo.setFee(qrInfoArr[4]);
                qrCodeInfo.setDate(qrInfoArr[5]);
                if (qrInfoArr.length > 6) {
                    qrCodeInfo.setCheckCode(qrInfoArr[6]);
                }
                if (qrInfoArr.length > 7) {
                    qrCodeInfo.setConfidentialInformation(qrInfoArr[7]);
                }
            } else if ("01".equals(qrInfoArr[1]) || "61".equals(qrInfoArr[1])) {
                qrCodeInfo = new QRCodeInfo();
                qrCodeInfo.setTaxBureau(qrInfoArr[0]);
                qrCodeInfo.setKind(qrInfoArr[1]);
                qrCodeInfo.setNumber(qrInfoArr[2]);
                qrCodeInfo.setFee(qrInfoArr[4]);
                qrCodeInfo.setDate(qrInfoArr[6]);
                qrCodeInfo.setConfidentialInformation(qrInfoArr[7]);
            } else if (qrInfoArr[0].contains("CZ-EI")) {
                qrCodeInfo = new QRCodeInfo();
                qrCodeInfo.setKind(qrInfoArr[0]);
                qrCodeInfo.setCode(qrInfoArr[2]);
                qrCodeInfo.setNumber(qrInfoArr[3]);
                qrCodeInfo.setFee(qrInfoArr[6]);
                qrCodeInfo.setDate(qrInfoArr[5]);
                qrCodeInfo.setCheckCode(qrInfoArr[4]);
            }
        } else if (qrInfoArr.length >= 5 && "10".equals(qrInfoArr[1])) {
            qrCodeInfo = new QRCodeInfo();
            qrCodeInfo.setTaxBureau(qrInfoArr[0]);
            qrCodeInfo.setKind(qrInfoArr[1]);
            qrCodeInfo.setNumber(qrInfoArr[2]);
            qrCodeInfo.setFee(qrInfoArr[3]);
            qrCodeInfo.setDate(qrInfoArr[4]);
            qrCodeInfo.setConfidentialInformation(qrInfoArr[5]);
        }
        return qrCodeInfo;
    }
}

