/*
 * Decompiled with CFR 0.152.
 */
package cn.com.szhtkj.tools;

import cn.com.szhtkj.gm.sm2strut.GBT35275Validate;
import cn.com.szhtkj.gm.sm2strut.VerifyInfo;
import cn.com.szhtkj.tools.FileTool;
import cn.com.szhtkj.tools.UUIDTool;
import cn.hutool.core.util.StrUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.Enumeration;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.asn1.ASN1Sequence;

public class ZipTool {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean verificationSignature(File zipfile) throws Exception {
        String tempPath = System.getProperty("java.io.tmpdir") + File.separator + "temp" + File.separator + UUIDTool.uuid() + "_temp";
        File tempDir = new File(tempPath);
        tempDir.mkdirs();
        try {
            boolean unZipOfd = ZipTool.unZip(zipfile, tempPath);
            if (!unZipOfd) {
                throw new Exception("\u9a8c\u7b7e\u5931\u8d25");
            }
            File[] listFiles = tempDir.listFiles();
            File xmlFile = null;
            File signFile = null;
            for (File file : listFiles) {
                if (file.getName().endsWith(".xml")) {
                    xmlFile = file;
                }
                if (!file.getName().endsWith(".sign")) continue;
                signFile = file;
            }
            Boolean bl = ZipTool.xbrlVerification(FileTool.file2ByteArray(xmlFile.getPath()), FileTool.readFileString(signFile.getPath()));
            return bl;
        }
        finally {
            FileTool.deleteDir(tempDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unZip(File file, String tempPath) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                int len;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    String dirPath = tempPath + File.separator + entry.getName();
                    File dir = new File(dirPath);
                    dir.mkdirs();
                    continue;
                }
                File targetFile = new File(tempPath + File.separator + entry.getName());
                if (!targetFile.getParentFile().exists()) {
                    targetFile.getParentFile().mkdirs();
                }
                targetFile.createNewFile();
                InputStream is = zipFile.getInputStream(entry);
                FileOutputStream fos = new FileOutputStream(targetFile);
                byte[] buf = new byte[1024];
                while ((len = is.read(buf)) != -1) {
                    fos.write(buf, 0, len);
                }
                fos.close();
                is.close();
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static boolean xbrlVerification(byte[] sourceData, String signedBase64) {
        if (sourceData == null) {
            throw new RuntimeException("\u539f\u6570\u636e\u4e3a\u7a7a");
        }
        if (signedBase64 == null) {
            throw new RuntimeException("\u7b7e\u540d\u6570\u636e\u4e3a\u7a7a");
        }
        try {
            byte[] signedData = cn.hutool.core.codec.Base64.decode((CharSequence)signedBase64);
            ASN1Sequence seq = ASN1Sequence.getInstance((Object)signedData);
            VerifyInfo verifyInfo = GBT35275Validate.validate("1.2.156.10197.1.501", sourceData, seq.getEncoded());
            return verifyInfo.result;
        }
        catch (Exception e) {
            throw new RuntimeException("\u9a8c\u7b7e\u5931\u8d25", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File extractXBRL(String zipFilePath, String outputFilePath) throws Exception {
        File xbrlFile;
        block7: {
            xbrlFile = null;
            File zipFile = new File(zipFilePath);
            if (Objects.nonNull(zipFile) && zipFile.exists()) {
                String tempPath = System.getProperty("java.io.tmpdir") + File.separator + "temp" + File.separator + UUIDTool.uuid() + "_temp";
                File tempDir = new File(tempPath);
                tempDir.mkdirs();
                try {
                    boolean unZipOfd = ZipTool.unZip(zipFile, tempPath);
                    if (unZipOfd) {
                        File[] listFiles = tempDir.listFiles();
                        File xmlFileFromZip = null;
                        for (File file : listFiles) {
                            if (!file.getName().endsWith(".xml")) continue;
                            xmlFileFromZip = file;
                        }
                        if (Objects.nonNull(xmlFileFromZip) && xmlFileFromZip.exists()) {
                            outputFilePath = StrUtil.isBlank((CharSequence)outputFilePath) ? System.getProperty("java.io.tmpdir") + File.separator + "xbrl" + File.separator + "xbrl_" + UUIDTool.uuid() + File.separator + xmlFileFromZip.getName() : outputFilePath + File.separator + xmlFileFromZip.getName();
                            xbrlFile = new File(outputFilePath);
                            FileUtils.copyFile((File)xmlFileFromZip, (File)xbrlFile);
                            break block7;
                        }
                        throw new Exception("\u4e0d\u662f\u6807\u51c6\u65b0\u8bd5\u70b9\u7968ZIP\u6587\u4ef6");
                    }
                    throw new Exception("\u89e3\u6790\u5931\u8d25");
                }
                finally {
                    FileTool.deleteDir(tempDir);
                }
            }
        }
        return xbrlFile;
    }

    public static byte[] uncompress(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream(Base64.getDecoder().decode(str));
        GZIPInputStream gunzip = null;
        try {
            int n;
            gunzip = new GZIPInputStream(in);
            byte[] buffer = new byte[256];
            while ((n = gunzip.read(buffer)) >= 0) {
                out.write(buffer, 0, n);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                gunzip.close();
            }
            catch (IOException iOException) {}
        }
        return out.toByteArray();
    }
}

