/*
 * Decompiled with CFR 0.152.
 */
package cn.com.szhtkj.xbrljson.convert;

import cn.com.szhtkj.tools.DateTool;
import cn.com.szhtkj.tools.PatternTool;
import cn.com.szhtkj.tools.PropTool;
import cn.com.szhtkj.xbrljson.config.model.JsonConfigItem;
import cn.com.szhtkj.xbrljson.config.model.XbrlJsonConfig;
import cn.com.szhtkj.xbrljson.model.Context;
import cn.com.szhtkj.xbrljson.model.ContextDim;
import cn.com.szhtkj.xbrljson.model.Entity;
import cn.com.szhtkj.xbrljson.model.InstData;
import cn.com.szhtkj.xbrljson.model.Xbrl;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class XbrlObjectCreator {
    private static final Logger log = Logger.getLogger(XbrlObjectCreator.class.toString());
    private static volatile XbrlObjectCreator xbrlCreator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static XbrlObjectCreator getInstance() {
        if (xbrlCreator != null) return xbrlCreator;
        Class<XbrlObjectCreator> clazz = XbrlObjectCreator.class;
        synchronized (XbrlObjectCreator.class) {
            if (xbrlCreator != null) return xbrlCreator;
            xbrlCreator = new XbrlObjectCreator();
            // ** MonitorExit[var0] (shouldn't be in output)
            return xbrlCreator;
        }
    }

    public Xbrl createXbrlData(XbrlJsonConfig configObject, JSONObject jsonObject) {
        if (configObject == null) {
            return null;
        }
        Xbrl xbrlTemp = configObject.getXbrlTemp();
        if (xbrlTemp == null) {
            return null;
        }
        Xbrl xbrlData = (Xbrl)xbrlTemp.clone();
        JsonConfigItem jsonConfigItem = configObject.getJsonConfig();
        if (jsonConfigItem == null) {
            return null;
        }
        this.calcExp(xbrlData, jsonObject);
        HashMap<String, JsonConfigItem> configItemMap = configObject.getJsonConfigMap();
        this.buildJsonDataToInst(xbrlData, jsonObject, configItemMap, "", null);
        return xbrlData;
    }

    private void buildJsonDataToInst(Xbrl xbrlData, JSONObject jsonObject, HashMap<String, JsonConfigItem> configItemMap, String parentId, InstData parentInstData) {
        if (jsonObject == null) {
            return;
        }
        Set keySet = jsonObject.keySet();
        if (keySet == null || keySet.size() == 0) {
            return;
        }
        String configKey = parentId;
        if (!StrUtil.isBlank((CharSequence)parentId)) {
            configKey = parentId + "-";
        }
        String nodeKey = null;
        for (String key : keySet) {
            nodeKey = configKey + key;
            Object item = jsonObject.get((Object)key);
            JsonConfigItem configItem = configItemMap.get(nodeKey);
            if (configItem == null) continue;
            InstData instData = this.createInstData(xbrlData, item, configItem, parentInstData);
            if (item instanceof JSONObject) {
                this.buildJsonDataToInst(xbrlData, (JSONObject)item, configItemMap, nodeKey, instData);
                continue;
            }
            if (!(item instanceof List)) continue;
            List itemList = (List)item;
            int childIndex = 0;
            for (Object childItem : itemList) {
                if (childItem instanceof JSONObject) {
                    if (childIndex != 0) {
                        InstData cloneInstData = (InstData)instData.clone();
                        if (parentInstData == null || !parentInstData.addChild(cloneInstData)) {
                            List<InstData> dataList = xbrlData.getInstDataList();
                            dataList.add(cloneInstData);
                        }
                        this.buildJsonDataToInst(xbrlData, (JSONObject)childItem, configItemMap, nodeKey, cloneInstData);
                    } else {
                        this.buildJsonDataToInst(xbrlData, (JSONObject)childItem, configItemMap, nodeKey, instData);
                    }
                } else {
                    log.info("\u65e0\u6cd5\u89e3\u6790\uff1a" + childItem.toString() + "---" + childItem.getClass().toString());
                }
                ++childIndex;
            }
        }
    }

    private InstData createInstData(Xbrl xbrlData, Object item, JsonConfigItem configItem, InstData parentInstData) {
        String value;
        InstData instData = new InstData();
        String eleName = configItem.getElementName();
        String nsName = configItem.getElementNsName();
        String dec = configItem.getDecimals();
        String controlData = configItem.getControlData();
        String valueType = configItem.getElementValueType();
        String contextType = configItem.getContextType();
        String unitId = configItem.getUnitId();
        if (StrUtil.isBlank((CharSequence)eleName) || StrUtil.isBlank((CharSequence)nsName)) {
            return null;
        }
        if (valueType.equals("tuple")) {
            instData = new InstData();
            HashMap<String, String> nameSpaceMap = xbrlData.getNameSpaceMap();
            instData.setElementName(eleName);
            instData.setElementNameSpaceUri(nameSpaceMap.get(nsName));
            instData.setElementNsName(nsName);
            instData.setChildList(new ArrayList<InstData>());
            if (parentInstData == null || !parentInstData.addChild(instData)) {
                List<InstData> dataList = xbrlData.getInstDataList();
                dataList.add(instData);
            }
            return instData;
        }
        ArrayList<ContextDim> dimensionList = new ArrayList<ContextDim>();
        String strValue = item.toString();
        Double numValue = null;
        if (!StrUtil.isBlank((CharSequence)dec) && valueType.equals("number")) {
            try {
                numValue = Double.valueOf(strValue);
            }
            catch (NumberFormatException e) {
                log.info(e.toString());
            }
        } else {
            dec = null;
            unitId = null;
        }
        if (valueType.equals("date")) {
            strValue = DateTool.formatDateValue(strValue);
        }
        Context context = this.createContext(xbrlData, dimensionList, contextType);
        if (!(StrUtil.isBlank((CharSequence)controlData) || StrUtil.isBlank((CharSequence)strValue) || StrUtil.isBlank((CharSequence)(value = PropTool.getPropValue(controlData, strValue))))) {
            strValue = value;
        }
        instData = this.createInstData(xbrlData, eleName, nsName, dec, unitId, context, strValue, numValue);
        if (valueType.equals("date") && StrUtil.isBlank((CharSequence)instData.getStrValue())) {
            instData.setNil("true");
        }
        if (parentInstData == null || !parentInstData.addChild(instData)) {
            List<InstData> dataList = xbrlData.getInstDataList();
            dataList.add(instData);
        }
        return instData;
    }

    private InstData createInstData(Xbrl xbrlData, String eleName, String nsName, String dec, String unitId, Context context, String strValue, Double numValue) {
        if (context == null) {
            return null;
        }
        InstData instData = new InstData();
        HashMap<String, String> nameSpaceMap = xbrlData.getNameSpaceMap();
        instData.setElementName(eleName);
        instData.setElementNameSpaceUri(nameSpaceMap.get(nsName));
        instData.setElementNsName(nsName);
        instData.setContextRef(context.getId());
        instData.setDecimals(dec);
        instData.setUnitRef(unitId);
        instData.setStrValue(strValue);
        instData.setValueType(1);
        if (numValue != null) {
            instData.setNumValue(numValue);
            instData.setValueType(0);
        }
        return instData;
    }

    private Context createContext(Xbrl xbrlData, List<ContextDim> dimensionList, String contextType) {
        String id;
        HashMap<String, Context> contextMap = xbrlData.getContextMap();
        String instant = xbrlData.getInstant();
        String startDate = xbrlData.getStartDate();
        String endDate = xbrlData.getEndDate();
        Context context = new Context();
        if (contextType.equals("instant")) {
            context.setPeriodType(0);
            context.setInstDate(instant);
        } else if (contextType.equals("duration")) {
            context.setPeriodType(1);
            context.setStartDate(startDate);
            context.setEndDate(endDate);
        }
        if (dimensionList != null) {
            context.setScenarioList(dimensionList);
        }
        if (contextMap.containsKey(id = "c1")) {
            return contextMap.get(id);
        }
        context.setId(id);
        contextMap.put(id, context);
        return context;
    }

    private void calcExp(Xbrl ret, JSONObject jsonObject) {
        if (ret == null || jsonObject == null) {
            return;
        }
        Entity entity = ret.getDefaultEntity();
        if (entity != null) {
            entity.setIdentifier(this.convertExpValue(entity.getIdentifier(), jsonObject));
        }
        if (!StrUtil.isBlank((CharSequence)ret.getInstant())) {
            ret.setInstant(this.convertExpValue(ret.getInstant(), jsonObject));
        }
    }

    public String convertExpValue(String expValue, JSONObject jsonObject) {
        String retValue = expValue;
        List<String> paramList = PatternTool.getFiledExpList(expValue);
        if (paramList != null && paramList.size() > 0) {
            for (String param : paramList) {
                Object value = this.getExpValue(param.substring(2, param.length() - 1), jsonObject);
                if (value == null) {
                    value = "null";
                }
                retValue = retValue.replace(param, value.toString());
            }
        }
        return retValue;
    }

    public Object getExpValue(String exp, JSONObject jsonObject) {
        if (StrUtil.isBlank((CharSequence)exp)) {
            return null;
        }
        if (jsonObject == null) {
            return null;
        }
        String[] paramList = exp.split("\\.");
        JSONObject operItem = jsonObject;
        Object retObj = null;
        for (String param : paramList) {
            retObj = null;
            Object item = operItem.get((Object)param);
            if (item == null) {
                return null;
            }
            if (item instanceof JSONObject) {
                operItem = (JSONObject)item;
                continue;
            }
            if (item instanceof JSONArray) {
                operItem = (JSONObject)((JSONArray)item).get(0);
                continue;
            }
            retObj = item;
        }
        return retObj;
    }
}

