/*
 * Decompiled with CFR 0.152.
 */
package cn.com.szhtkj.xbrljson.outputer.impl;

import cn.com.szhtkj.tools.DateTool;
import cn.com.szhtkj.tools.NumberTool;
import cn.com.szhtkj.xbrljson.model.Context;
import cn.com.szhtkj.xbrljson.model.ContextDim;
import cn.com.szhtkj.xbrljson.model.Entity;
import cn.com.szhtkj.xbrljson.model.ExplicitMember;
import cn.com.szhtkj.xbrljson.model.InstData;
import cn.com.szhtkj.xbrljson.model.SchemaRef;
import cn.com.szhtkj.xbrljson.model.TypedMember;
import cn.com.szhtkj.xbrljson.model.Unit;
import cn.com.szhtkj.xbrljson.model.Xbrl;
import cn.com.szhtkj.xbrljson.outputer.XbrlOutputer;
import cn.hutool.core.util.StrUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.logging.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class BaseXbrlOutputer
implements XbrlOutputer {
    private static final Logger log = Logger.getLogger(BaseXbrlOutputer.class.toString());

    @Override
    public String getXbrlXml(Xbrl xbrlData) throws Exception {
        if (xbrlData == null) {
            return null;
        }
        Document doc = this.createXbrlDoc(xbrlData);
        if (doc != null && doc.getRootElement() != null) {
            return doc.getRootElement().asXML();
        }
        return null;
    }

    @Override
    public boolean exportXbrl(Xbrl xbrlData, String savePath, String fileName, boolean exportTaxonomy) throws Exception {
        if (xbrlData == null) {
            return false;
        }
        if (StrUtil.isBlank((CharSequence)savePath)) {
            return false;
        }
        if (StrUtil.isBlank((CharSequence)fileName)) {
            fileName = UUID.randomUUID() + ".xml";
        }
        Document doc = this.createXbrlDoc(xbrlData);
        this.exportFile(doc, savePath, fileName);
        return true;
    }

    private Document createXbrlDoc(Xbrl xbrlData) {
        Document doc = this.createDocument();
        Element xbrlNode = null;
        xbrlNode = doc.addElement("xbrl", "http://www.xbrl.org/2003/instance");
        this.createNameSpace(xbrlNode, xbrlData.getNameSpaceMap());
        xbrlNode.addAttribute("xsi:schemaLocation", "http://www.xbrl.org/2003/linkbase http://www.xbrl.org/2003/xbrl-linkbase-2003-12-31.xsd");
        this.createSchemaRef(xbrlNode, xbrlData.getSchemaRef());
        this.createContext(xbrlNode, xbrlData.getContextMap(), xbrlData);
        this.createUnit(xbrlNode, xbrlData.getUnitList());
        this.createInstData(xbrlNode, xbrlData.getInstDataList());
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exportFile(Document doc, String path, String fileName) throws IOException {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("UTF-8");
        File f = new File(path);
        if (!f.exists()) {
            f.mkdirs();
        }
        f = new File(path, fileName);
        FileOutputStream fileOutputStream = null;
        XMLWriter write = null;
        try {
            fileOutputStream = new FileOutputStream(f.getAbsoluteFile());
            write = new XMLWriter((OutputStream)fileOutputStream, format);
            log.info(doc.getRootElement().asXML());
            write.write(doc);
        }
        finally {
            if (null != fileOutputStream) {
                fileOutputStream.close();
            }
            if (null != write) {
                write.close();
            }
        }
        log.info("\u751f\u6210\u6587\u4ef6\u6210\u529f\uff0c\u6587\u4ef6\u8def\u5f84\uff1a" + f.getAbsolutePath());
        return true;
    }

    private void createInstData(Element parentNode, List<InstData> instDataList) {
        if (instDataList == null) {
            return;
        }
        for (InstData instData : instDataList) {
            List<InstData> childList;
            String lang;
            String unitId;
            Element dataNode = parentNode.addElement(instData.getElementNsName() + ":" + instData.getElementName());
            dataNode.addAttribute("contextRef", instData.getContextRef());
            String strValue = instData.getStrValue();
            Double numValue = instData.getNumValue();
            String val = strValue;
            String nil = instData.getNil();
            boolean isNil = !StrUtil.isBlank((CharSequence)nil) && "true".equalsIgnoreCase(nil);
            String id = instData.getId();
            if (!StrUtil.isBlank((CharSequence)id)) {
                dataNode.addAttribute("id", id);
            }
            if (!StrUtil.isBlank((CharSequence)(unitId = instData.getUnitRef()))) {
                dataNode.addAttribute("unitRef", unitId);
            }
            if (!StrUtil.isBlank((CharSequence)(lang = instData.getLang()))) {
                dataNode.addAttribute("xml:lang", lang);
            }
            String dec = instData.getDecimals();
            String precision = instData.getPrecision();
            if (!StrUtil.isBlank((CharSequence)dec)) {
                try {
                    val = NumberTool.getNoTailZeroString(numValue, dec);
                }
                catch (NumberFormatException e) {
                    log.info(e.toString());
                }
            }
            if (!isNil && !StrUtil.isBlank((CharSequence)dec)) {
                dataNode.addAttribute("decimals", dec);
            }
            if (!isNil && !StrUtil.isBlank((CharSequence)precision)) {
                dataNode.addAttribute("precision", precision);
            }
            if (isNil) {
                dataNode.addAttribute("xsi:nil", "true");
            } else if (val != null) {
                dataNode.setText(val);
            }
            if ((childList = instData.getChildList()) == null || childList.size() <= 0) continue;
            this.createInstData(dataNode, childList);
        }
    }

    private void createUnit(Element parentNode, HashMap<String, Unit> unitMap) {
        if (unitMap == null) {
            return;
        }
        for (Unit item : unitMap.values()) {
            Element mNode;
            Element unNode;
            Element uNode = parentNode.addElement("unit");
            uNode.addAttribute("id", item.getId());
            List<String> measureList = item.getMeasureList();
            if (measureList != null && measureList.size() > 0) {
                for (String m : measureList) {
                    Element mNode2 = uNode.addElement("measure");
                    mNode2.setText(m);
                }
            }
            List<String> numeratorList = item.getNumeratorList();
            List<String> denominatorList = item.getDenominatorList();
            if (numeratorList == null || denominatorList == null || numeratorList.size() <= 0 || denominatorList.size() <= 0) continue;
            Element dNode = uNode.addElement("divide");
            if (numeratorList != null) {
                for (String Numerator : numeratorList) {
                    unNode = dNode.addElement("unitNumerator");
                    mNode = unNode.addElement("measure");
                    mNode.setText(Numerator);
                }
            }
            if (denominatorList == null) continue;
            for (String Numerator : denominatorList) {
                unNode = dNode.addElement("unitDenominator");
                mNode = unNode.addElement("measure");
                mNode.setText(Numerator);
            }
        }
    }

    private void createContext(Element parentNode, HashMap<String, Context> contextMap, Xbrl xbrlData) {
        if (contextMap == null || contextMap.size() == 0) {
            return;
        }
        Entity defaultEntity = xbrlData.getDefaultEntity();
        for (Context context : contextMap.values()) {
            if (defaultEntity != null) {
                if (StrUtil.isBlank((CharSequence)context.getScheme())) {
                    context.setScheme(defaultEntity.getScheme());
                }
                if (StrUtil.isBlank((CharSequence)context.getIdentifier())) {
                    context.setIdentifier(defaultEntity.getIdentifier());
                }
            }
            this.createContextNode(parentNode, context);
        }
    }

    public Element createContextNode(Element parentNode, Context context) {
        List<ContextDim> segmentList;
        if (parentNode == null) {
            return null;
        }
        Context item = context;
        Element cNode = parentNode.addElement("context");
        cNode.addAttribute("id", item.getId());
        Element entityNode = cNode.addElement("entity");
        Element identifierNode = entityNode.addElement("identifier");
        if (item.getScheme() != null) {
            identifierNode.addAttribute("scheme", item.getScheme());
        }
        if (item.getIdentifier() != null) {
            identifierNode.setText(item.getIdentifier());
        }
        Element periodNode = cNode.addElement("period");
        Element subNode = null;
        int periodType = item.getPeriodType();
        if (periodType == 0) {
            subNode = periodNode.addElement("instant");
            subNode.setText(DateTool.formatDateValue(item.getInstDate()));
        } else if (periodType == 1) {
            subNode = periodNode.addElement("startDate");
            subNode.setText(DateTool.formatDateValue(item.getStartDate()));
            subNode = periodNode.addElement("endDate");
            subNode.setText(DateTool.formatDateValue(item.getEndDate()));
        }
        List<ContextDim> scenarioList = item.getScenarioList();
        if (scenarioList != null && scenarioList.size() > 0) {
            Element scenarioNode = cNode.addElement("scenario");
            for (ContextDim dim : scenarioList) {
                this.createContextDimNode(dim, scenarioNode);
            }
        }
        if ((segmentList = item.getSegmentList()) != null && segmentList.size() > 0) {
            Element segmentNode = entityNode.addElement("segment");
            for (ContextDim dim : segmentList) {
                this.createContextDimNode(dim, segmentNode);
            }
        }
        return cNode;
    }

    private void createContextDimNode(ContextDim dim, Element dimNode) {
        Element subNode = null;
        if (dim instanceof TypedMember) {
            TypedMember ym = (TypedMember)dim;
            subNode = dimNode.addElement("xbrldi:typedMember");
            subNode.addAttribute("dimension", ym.getDimension());
            if (!StrUtil.isBlank((CharSequence)ym.getMember())) {
                Element typeMemNode = subNode.addElement(ym.getMember());
                String memberValue = ym.getMemberValue();
                if (!StrUtil.isBlank((CharSequence)memberValue)) {
                    typeMemNode.setText(memberValue);
                }
            }
        } else if (dim instanceof ExplicitMember) {
            ExplicitMember em = (ExplicitMember)dim;
            subNode = dimNode.addElement("xbrldi:explicitMember");
            subNode.addAttribute("dimension", em.getDimension());
            subNode.setText(em.getMember());
        }
    }

    private void createSchemaRef(Element parentNode, SchemaRef schemaRef) {
        if (schemaRef == null) {
            return;
        }
        Element node = parentNode.addElement("link:schemaRef");
        node.addAttribute("xlink:type", schemaRef.getType());
        node.addAttribute("xlink:href", schemaRef.getHref());
        node.addAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        node.addAttribute("xmlns:link", "http://www.xbrl.org/2003/linkbase");
    }

    private Document createDocument() {
        Document doc = DocumentHelper.createDocument();
        return doc;
    }

    public void createNameSpace(Element node, HashMap<String, String> nameSpaceMap) {
        if (node == null) {
            return;
        }
        if (nameSpaceMap == null || nameSpaceMap.size() == 0) {
            return;
        }
        for (String prefix : nameSpaceMap.keySet()) {
            String uri = nameSpaceMap.get(prefix);
            node.add(new Namespace(prefix, uri));
        }
    }
}

