/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.gm.ses.v4;

import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.ofdrw.gm.ses.v4.TBS_Sign;

public class SES_Signature
extends ASN1Object {
    private TBS_Sign toSign;
    private ASN1OctetString cert;
    private ASN1ObjectIdentifier signatureAlgID;
    private ASN1BitString signature;
    private ASN1BitString timeStamp;

    public SES_Signature() {
    }

    public SES_Signature(TBS_Sign toSign, ASN1OctetString cert, ASN1ObjectIdentifier signatureAlgID, ASN1BitString signature, ASN1BitString timeStamp) {
        this.toSign = toSign;
        this.cert = cert;
        this.signatureAlgID = signatureAlgID;
        this.signature = signature;
        this.timeStamp = timeStamp;
    }

    public SES_Signature(ASN1Sequence seq) {
        Object obj;
        Enumeration e = seq.getObjects();
        this.toSign = TBS_Sign.getInstance(e.nextElement());
        if (e.hasMoreElements()) {
            obj = e.nextElement();
            if (obj instanceof ASN1OctetString) {
                this.cert = ASN1OctetString.getInstance(obj);
            } else if (obj instanceof ASN1ObjectIdentifier) {
                this.signatureAlgID = ASN1ObjectIdentifier.getInstance(obj);
            } else if (obj instanceof DERBitString) {
                this.signature = DERBitString.getInstance(obj);
            } else if (obj instanceof ASN1TaggedObject) {
                this.timeStamp = DERBitString.getInstance((Object)((ASN1TaggedObject)obj).getObject());
            }
        }
        if (e.hasMoreElements()) {
            obj = e.nextElement();
            if (obj instanceof ASN1ObjectIdentifier) {
                this.signatureAlgID = ASN1ObjectIdentifier.getInstance(obj);
            } else if (obj instanceof DERBitString) {
                this.signature = DERBitString.getInstance(obj);
            } else if (obj instanceof ASN1TaggedObject) {
                this.timeStamp = DERBitString.getInstance((Object)((ASN1TaggedObject)obj).getObject());
            }
        }
        if (e.hasMoreElements()) {
            obj = e.nextElement();
            if (obj instanceof DERBitString) {
                this.signature = DERBitString.getInstance(obj);
            } else if (obj instanceof ASN1TaggedObject) {
                this.timeStamp = DERBitString.getInstance((Object)((ASN1TaggedObject)obj).getObject());
            }
        }
        if (e.hasMoreElements() && (obj = e.nextElement()) instanceof ASN1TaggedObject) {
            this.timeStamp = DERBitString.getInstance((Object)((ASN1TaggedObject)obj).getObject());
        }
    }

    public static SES_Signature getInstance(Object o) {
        if (o instanceof SES_Signature) {
            return (SES_Signature)((Object)o);
        }
        if (o instanceof byte[]) {
            ASN1InputStream aIn = new ASN1InputStream((byte[])o);
            try {
                ASN1Primitive obj = aIn.readObject();
                return new SES_Signature(ASN1Sequence.getInstance((Object)obj));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("\u7535\u5b50\u7b7e\u7ae0\u6570\u636ev4 \u65e0\u6cd5\u89e3\u6790", e);
            }
        }
        if (o != null) {
            return new SES_Signature(ASN1Sequence.getInstance((Object)o));
        }
        return null;
    }

    public TBS_Sign getToSign() {
        return this.toSign;
    }

    public SES_Signature setToSign(TBS_Sign toSign) {
        this.toSign = toSign;
        return this;
    }

    public ASN1OctetString getCert() {
        return this.cert;
    }

    public SES_Signature setCert(ASN1OctetString cert) {
        this.cert = cert;
        return this;
    }

    public SES_Signature setCert(Certificate cert) throws CertificateEncodingException {
        this.cert = new DEROctetString(cert.getEncoded());
        return this;
    }

    public ASN1ObjectIdentifier getSignatureAlgID() {
        return this.signatureAlgID;
    }

    public SES_Signature setSignatureAlgID(ASN1ObjectIdentifier signatureAlgID) {
        this.signatureAlgID = signatureAlgID;
        return this;
    }

    public ASN1BitString getSignature() {
        return this.signature;
    }

    public SES_Signature setSignature(ASN1BitString signature) {
        this.signature = signature;
        return this;
    }

    public SES_Signature setSignature(byte[] signature) {
        this.signature = new DERBitString(signature);
        return this;
    }

    public ASN1BitString getTimeStamp() {
        return this.timeStamp;
    }

    public SES_Signature setTimeStamp(ASN1BitString timeStamp) {
        this.timeStamp = timeStamp;
        return this;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector(5);
        v.add((ASN1Encodable)this.toSign);
        v.add((ASN1Encodable)this.cert);
        v.add((ASN1Encodable)this.signatureAlgID);
        v.add((ASN1Encodable)this.signature);
        if (this.timeStamp != null) {
            v.add((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)this.timeStamp));
        }
        return new DERSequence(v);
    }
}

